/************************
 *  REUNION LIST SLIDER *
 ************************/

(function() {
  // store the slider in a local variable
  var $window = $(window),
    flexslider = {
      vars: {},
    };

  function getMarginSize() {
    return window.innerWidth < 600 ? 12 : 24;
  }

  $(function() {
    $('.o-reunionList__carousel').flexslider({
      animation: 'slide',
      animationLoop: false,
      itemWidth: 320,
      itemMargin: getMarginSize(),
      minItems: 1,
      maxItems: 6,
      slideshow: false,
      directionNav: true,
    });
  });

  $window.resize(function() {
    var marginSize = getMarginSize();
    flexslider.vars.itemMargin = marginSize;
    flexslider.vars.itemMargin = marginSize;
  });
})();

/****************
 *  NEWS SLIDER *
 ****************/

(function() {
  // store the slider in a local variable
  var $window = $(window),
    flexslider = {
      vars: {},
    };
  function getDirection() {
    return window.innerWidth < 600 ? 'horizontal' : 'vertical';
  }
  $(function() {
    $('.o-newsSection__carousel').flexslider({
      animation: 'slide',
      animationLoop: false,
      direction: getDirection(),
      itemMargin: 0,
      slideshow: false,
      directionNav: false,
    });
  });
  $window.resize(function() {
    var direction = getDirection();
    flexslider.vars.direction = direction;
    flexslider.vars.direction = direction;
  });
})();

/********************
 *  PARTNERS SLIDER *
 ********************/

(function() {
  // removes a flexslider
  function flexdestroy($el) {
    var $elClean = $el.clone();
    $elClean
      .find('.flex-viewport')
      .children()
      .unwrap();
    $elClean
      .removeClass('flexslider')
      .find('.clone, .flex-direction-nav, .flex-control-nav')
      .remove()
      .end()
      .find('*')
      .removeAttr('style')
      .removeClass(function(index, css) {
        // If element is SVG css has an Object inside (?)
        if (typeof css === 'string') {
          return (css.match(/\bflex\S+/g) || []).join(' ');
        }
      });
    $elClean.insertBefore($el);
    $el.remove();
  }

  // initializes partners slider
  function initPartnersSlider($el, itemMargin, itemWidth) {
    $el.flexslider({
      animation: 'slide',
      animationLoop: false,
      direction: 'horizontal',
      itemMargin: itemMargin,
      itemWidth: itemWidth,
      slideshow: false,
      directionNav: false,
    });
  }

  // creates or removes partner slider depending whether there's enough space available
  function checkSlider() {
    var $el = $('.o-partners__carousel').first();
    var itemMargin = 36;
    var itemWidth = 173;
    var spaceRequired =
      $el.find('.o-partners__item').length * (itemMargin + itemWidth);
    if (spaceRequired > $el.innerWidth()) {
      initPartnersSlider($el, itemMargin, itemWidth);
      $el.addClass('-active');
    } else {
      $el.removeClass('-active');
      flexdestroy($el);
    }
  }

  $(function() {
    checkSlider();
    $(window).resize(function() {
      checkSlider();
    });
  });
})();
