google.maps.event.addDomListener(window, 'load', init);

function init() {
  // Basic options for a simple Google Map
  // For more options see: https://developers.google.com/maps/documentation/javascript/reference#MapOptions
  var mapOptions = {
    // How zoomed in you want the map to start at (always required)
    zoom: 5,

    // The latitude and longitude to center the map (always required)
    center: new google.maps.LatLng(44.5, 3),

    disableDefaultUI: true,

    // How you would like to style the map.
    // This is where you would paste any style found on Snazzy Maps.
    styles: [
      {
        featureType: 'water',
        elementType: 'geometry',
        stylers: [{ color: '#e9e9e9' }, { lightness: 17 }],
      },
      {
        featureType: 'landscape',
        elementType: 'geometry',
        stylers: [{ color: '#f5f5f5' }, { lightness: 20 }],
      },
      {
        featureType: 'road.highway',
        elementType: 'geometry.fill',
        stylers: [{ color: '#ffffff' }, { lightness: 17 }],
      },
      {
        featureType: 'road.highway',
        elementType: 'geometry.stroke',
        stylers: [{ color: '#ffffff' }, { lightness: 29 }, { weight: 0.2 }],
      },
      {
        featureType: 'road.arterial',
        elementType: 'geometry',
        stylers: [{ color: '#ffffff' }, { lightness: 18 }],
      },
      {
        featureType: 'road.local',
        elementType: 'geometry',
        stylers: [{ color: '#ffffff' }, { lightness: 16 }],
      },
      {
        featureType: 'poi',
        elementType: 'geometry',
        stylers: [{ color: '#f5f5f5' }, { lightness: 21 }],
      },
      {
        featureType: 'poi.park',
        elementType: 'geometry',
        stylers: [{ color: '#dedede' }, { lightness: 21 }],
      },
      {
        elementType: 'labels.text.stroke',
        stylers: [
          { visibility: 'on' },
          { color: '#ffffff' },
          { lightness: 16 },
        ],
      },
      {
        elementType: 'labels.text.fill',
        stylers: [{ saturation: 36 }, { color: '#333333' }, { lightness: 40 }],
      },
      { elementType: 'labels.icon', stylers: [{ visibility: 'off' }] },
      {
        featureType: 'transit',
        elementType: 'geometry',
        stylers: [{ color: '#f2f2f2' }, { lightness: 19 }],
      },
      {
        featureType: 'administrative',
        elementType: 'geometry.fill',
        stylers: [{ color: '#fefefe' }, { lightness: 20 }],
      },
      {
        featureType: 'administrative',
        elementType: 'geometry.stroke',
        stylers: [{ color: '#fefefe' }, { lightness: 17 }, { weight: 1.2 }],
      },
    ],
  };

  // Get the HTML DOM element that will contain your map
  // We are using a div with id="map" seen below in the <body>
  var mapElement = document.getElementById('locatorMap');

  // Create the Google Map using our element and options defined above
  var map = new google.maps.Map(mapElement, mapOptions);

  var icon = 'images/svg/pin.svg';

  // Let's also add a marker while we're at it
  var markerParis = new google.maps.Marker({
    position: new google.maps.LatLng(48.89371, 2.3543),
    map: map,
    icon: icon,
    title: 'Paris',
  });
  var markerNantes = new google.maps.Marker({
    position: new google.maps.LatLng(47.20835, -1.53018),
    map: map,
    icon: icon,
    title: 'Nantes',
  });
  var markerRennes = new google.maps.Marker({
    position: new google.maps.LatLng(48.10562, -1.71821),
    map: map,
    icon: icon,
    title: 'Rennes',
  });
  var markerGrenoble = new google.maps.Marker({
    position: new google.maps.LatLng(45.19071, 5.71883),
    map: map,
    icon: icon,
    title: 'Grenoble',
  });
  var markerMarseille = new google.maps.Marker({
    position: new google.maps.LatLng(43.30932, 5.38921),
    map: map,
    icon: icon,
    title: 'Marseille',
  });
  var markerStrasbourg = new google.maps.Marker({
    position: new google.maps.LatLng(43.30932, 5.38921),
    map: map,
    icon: icon,
    title: 'Strasbourg',
  });
  var markerLille = new google.maps.Marker({
    position: new google.maps.LatLng(50.70059, 3.15729),
    map: map,
    icon: icon,
    title: 'Lille',
  });
  var markerAix = new google.maps.Marker({
    position: new google.maps.LatLng(43.52773, 5.4347),
    map: map,
    icon: icon,
    title: 'Aix-en-Provence',
  });
  var markerToulouse = new google.maps.Marker({
    position: new google.maps.LatLng(43.60263, 1.454),
    map: map,
    icon: icon,
    title: 'Toulouse',
  });
  var markerTunis = new google.maps.Marker({
    position: new google.maps.LatLng(36.84607, 10.18944),
    map: map,
    icon: icon,
    title: 'Tunis (Tunisie)',
  });
}
